\version "2.18.0"
\language "deutsch"

\paper {
  %system-system-spacing = #'((basic-distance . 20))
  %markup-system-spacing = #'((basic-distance . 30))
  left-margin = 1.5\cm
  line-width = 19.3\cm
  print-page-number = false
  top-margin = 8\mm
  bottom-margin = 3\mm
  ragged-last-bottom=##f
  system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Pe Tine Te lăudăm"
  subtitle = "glasul 5"
  composer = "arm. după N. Lungu"
  %meter = "Andante religioso-cantabile"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key f \minor
  \time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Pe Ti -- ne __ Te __ lă -- u -- dăm, __
  Pe Ti -- ne __ bi -- ne __ Te __ cu -- vân -- tăm. __
  Ţi -- e Îţi mul -- ţu -- mim __ Doam -- ne
  şi ne ru -- găm __ Ţi -- e, Dum -- ne -- ze -- u -- lui __ nos -- tru. __
}

menWords = \lyricmode {
  Pe Ti -- ne Te lă -- u -- dăm, __
  Pe Ti -- ne bi -- ne __ Te cu -- vân -- tăm. __
  Ţi -- e Îţi mul -- ţu -- mim Doam -- ne
  şi ne ru -- găm Ţi -- e, Dum -- ne -- ze -- u -- lui __ nos -- tru. __
  Ne ru -- găm, __ ne ru -- găm. __
}
sopMusic = \relative c' {
  % Pre Tine Te lăudăm,
  \partial 4 h'4\rest
  h4\rest a4
  f'2
  \tuplet 3/2 { g8[( f8 e8~)] } e4
  \tuplet 3/2 { f8[( e8 d8~)] } d4
  \tuplet 3/2 { e8[( d8 c8~)] } c4
  d4( c8[ d8])
  e2~
  e4

  % Pre Tine bine Te cuvântăm.
  h4\rest
  h4\rest a4^\p
  f'4( a4)
  \tuplet 3/2 { g8[( f8 e8~)] } e4
  \tuplet 3/2 { f8[( e8 d8~)] } d4
  \tuplet 3/2 { e8[( d8 c8~)] } c4
  \tuplet 3/2 { d8[( c8 h8~)] } h4
  \tuplet 3/2 { c8[( h8 a8~)] } a4
  gis4( fis8[ gis8)]
  a2~^\>
  a4\! h4\rest

  % Ţie Îţi mulţumim, Doamne,
  c4~^\accent c16([ h16 d16 c16])
  h2
  \autoBeamOff
  h4^\> d8 e8\!
  \autoBeamOn
  f4( e4)
  d4( e8[ f8)]
  e2^\>

  % Şi ne rugăm Ţie, Dumnezeului nostru
  \autoBeamOff
  e4\!^\p e8 e8
  \autoBeamOn
  a4( g4)
  \acciaccatura g8 f8([ e8 d8 f8)]
  e2^\>
  c4\! c4
  f8([ e8 d8 e8)]
  c8([ d8 c8 h8)]
  a4( h8[ c8])
  d8([ c16 d16] c8[ h8]
  a4 gis4)^\>
  a2~\!^\pp^\>
  a2~\!
  a2~^\<
  a2~\!^\>
  a2~\!^\ppp
  a4^\fermata h4\rest \bar "|."
}

altoMusic = \relative c' {
  % Pre Tine Te lăudăm,
  \partial 4 h'4\rest
  h4\rest a4
  d2
  \tuplet 3/2 { e8[( d8 c8~)] } c4
  \tuplet 3/2 { d8[( c8 h8~)] } h4
  \tuplet 3/2 { c8[( h8 a8~)] } a4
  a2
  gis2~
  gis4

  % Pre Tine bine Te cuvântăm.
  h4\rest
  h4\rest a4
  d4( f4)
  \tuplet 3/2 { e8[( d8 c8~)] } c4
  \tuplet 3/2 { d8[( c8 h8~)] } h4
  \tuplet 3/2 { c8[( h8 a8~)] } a4
  \tuplet 3/2 { h8[( a8 gis8~)] } gis4
  \tuplet 3/2 { a8[( gis8 a8~)] } a4
  gis4( fis8[ gis8)]
  a2~
  a4 h4\rest

  % Ţie Îţi mulţumim, Doamne,
  a2
  g2
  \autoBeamOff
  g4 h8 c8
  \autoBeamOn
  d4( c4)
  h4( c8[ d8)]
  c2

  % Şi ne rugăm Ţie, Dumnezeului nostru
  \autoBeamOff
  c4 d8 d8
  \autoBeamOn
  c4( e4)
  d8([ c8 h8 d8)]
  c2
  c4 c4
  d8([ c8 h8 c8)]
  a8([ h8 a8 gis8)]
  a4( gis8[ a8])
  h8([ a16 h16] a8[ gis8]
  a4 gis4)
  a2~
  a2~
  a2~
  a2~
  a2~
  a4 h4\rest
}

tenorMusic = \relative c' {
  % Pre Tine Te lăudăm,
  \partial 4 a4^\pp
  a2~
  a2
  a2
  a2
  a2
  f2
  e2~
  e4 \breathe

  % Pre Tine bine Te cuvântăm.
  a4
  a2~
  a2
  a2
  d,4( e4)
  e4( f4)
  e2
  e2
  e2
  e2~^\>
  e4\! d4\rest

  % Ţie Îţi mulţumim, Doamne,
  a'4(^\accent f4)^\>
  g2\!
  \autoBeamOff
  g4^\< g8 g8\!
  g2
  g2
  g2^\>
  
  % Şi ne rugăm Ţie, Dumnezeului nostru  
  c4\!^\p h8 gis8
  \autoBeamOn
  a2
  a2
  a2^\>
  a4\! a4
  a4( e4)
  e2
  f4( e4)
  e2~
  e2
  e2~^\pp^\>
  e4\!

  % Ne rugăm, ne rugăm.
  \autoBeamOff
  e8 e8^\<
  f2~\!^\>
  f4\! \breathe f8^\accent f8^\accent
  \autoBeamOn
  e2~^\ppp
  e4^\fermata d4\rest
}

bassMusic = \relative c' {
  % Pre Tine Te lăudăm,
  \partial 4 a4
  a2~
  a2
  a2
  a2
  a2
  f2
  e2~
  e4 \breathe

  % Pre Tine bine Te cuvântăm.
  a4
  a2~
  a2
  a,2
  d4( e4)
  e4( f4)
  e2
  e2
  e2
  a,2~
  a4 d4\rest

  % Ţie Îţi mulţumim, Doamne,
  a'4( f4)
  g2
  \autoBeamOff
  g4 g8 g8
  g2
  g2
  c,2
  
  % Şi ne rugăm Ţie, Dumnezeului nostru  
  c'4 h8 gis8
  \autoBeamOn
  a2
  a2
  a2
  a4 a4
  d,4( e4)
  e2
  f4( e4)
  e2~
  e2
  a,2~
  a4

  % Ne rugăm, ne rugăm.
  \autoBeamOff
  a8 a8
  d2~
  d4 d8 d8
  \autoBeamOn
  a2~
  a4 d4\rest
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \transpose a f \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \transpose a f \altoMusic }
    >>

    \new Staff = "men" <<
      \clef bass
      \new Voice { \voiceOne \global \transpose a f \tenorMusic }
      \new Voice { \voiceTwo \global \transpose a f \bassMusic }
      \addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}


midiOutput = \midi {
    \tempo 4 = 40
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \transpose a f \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \transpose a f \altoMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \transpose a f \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \transpose a f \bassMusic }
  \midi { \midiOutput }
}